
#include "amg_msl_common.h"

#ifndef __RAY_TYPE
#define __RAY_TYPE
//
// Ray
//
struct Ray {
    float3 msl_origin;
    float3 msl_direction;
};

bool Ray_equal(Ray a,Ray b) {
    return all(a.msl_origin == b.msl_origin)
        && all(a.msl_direction == b.msl_direction);
}

Ray __Ray_ctor(float3 o, float3 d)
{
    Ray r;
    r.msl_origin = o;
    r.msl_direction = d;
    return r;
}

#endif // __RAY_TYPE

#ifndef __TEXTURECUBE
#define __TEXTURECUBE

float4 __texCUBE(TextureCube <float4> tex, SamplerState smp, float3 coord)
{
    return tex.SampleGrad(smp, coord,
                   __differential_scale * ddx(coord),
                   __differential_scale * ddy(coord));
}

float4 __texCUBE(TextureCube <float4> tex, SamplerState smp, float3 coord,float3 coord_dx, float3 coord_dy)
{
    return tex.SampleGrad(smp, coord, coord_dx, coord_dy);
}

float4 __texCUBE(TextureCube <float4> tex, SamplerState smp, float4 props, float3 coord, float3 blur)
{
    return tex.SampleGrad(smp, coord,
                   __differential_scale * ddx(coord) * blur,
                   __differential_scale * ddy(coord) * blur);
}

float4 __texCUBE(TextureCube <float4> tex, SamplerState smp, float4 props, float3 coord, float3 blur, int filter)
{
    if(filter == 6)
        return tex.SampleLevel(smp, _grid_snap(props, coord), 0.0);
    else
        return tex.SampleGrad(smp, coord,
                       __differential_scale * ddx(coord) * blur,
                       __differential_scale * ddy(coord) * blur);
}

float4 __texCUBE(TextureCube <float4> tex, SamplerState smp, float4 props, float3 coord, float3 coord_dx, float3 coord_dy, float3 blur)
{
    return tex.SampleGrad(smp, coord,
                   coord_dy * blur,
                   coord_dy * blur);
}

float4 __texCUBE(TextureCube <float4> tex, SamplerState smp, float4 props, float3 coord, float3 coord_dx, float3 coord_dy, float3 blur, int filter)
{
    if(filter == 6)
        return tex.SampleLevel(smp, _grid_snap(props, coord), 0.0);
    else
        return tex.SampleGrad(smp, coord,
                       coord_dy * blur,
                       coord_dy * blur);
}

#endif // __TEXTURECUBE


float4 __trace_environment(
    inout State state,
    Ray msl_ray)
{
	return float4(0, 0, 0, 0);
}
